/*
 * AprovarLocal.java
 *
 * Created on 10 de junio de 2008, 19:55
 */

package actions;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.sql.DataSource;
import locals.Local;

import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionForward;
/**
 *
 * @author dai
 * @version
 */

public class ModificarLocal extends Action {
    
    DataSource ds = null;
    Connection con = null;
    String sql = "";
    
    public ActionForward execute(ActionMapping mapping, ActionForm  form,
            HttpServletRequest request, HttpServletResponse response)
            throws Exception {
        
        Local local = (Local) form;
        
        try{
            ds = this.getDataSource(request);
            con = ds.getConnection();
            Statement st = con.createStatement();
            PreparedStatement sentencia = null;
            ResultSet rs = null;
            
            rs = st.executeQuery("SELECT COUNT(*) FROM immoble_local WHERE id_immoble = "+local.getIdLocal()+" OR id_local = "+local.getIdLocal());
            rs.next();
            if (rs.getInt(1) > 0) {
                local.setError("<font color='red'>No es pot modificar el tipus de local ja que te locals afegits o perteneix a un immoble</font>");
                return mapping.findForward("ok");
            }
            
            sentencia = con.prepareStatement("SELECT * FROM locals WHERE id_zona = ? AND UPPER(adresa) LIKE ? AND id != ?");
            sentencia.setInt(1, local.getIdZona());
            sentencia.setString(2, local.getAdresa().toUpperCase().trim());
            sentencia.setInt(3, local.getIdLocal());
            rs = sentencia.executeQuery();
            if (rs.next()) {
                local.setError("<font color='red'>Hi ha camps que ja estan a la base de dades</font>");
                return mapping.findForward("ok");
            }
            
            if (request.getSession().getAttribute("usuariagent") != null) {
                sql = "UPDATE locals SET adresa = ?, caracteristiques = ?, superficie = ?";
                if (local.getIdZona() > 0)
                    sql += ", id_zona = ?";
                sql += " WHERE id = ?";
                sentencia = con.prepareStatement(sql);
                sentencia.setString(1, local.getAdresa());
                sentencia.setString(2, local.getCaracteristiques());
                sentencia.setFloat(3, local.getSuperficie());
                if (local.getIdZona() > 0){
                    sentencia.setInt(4, local.getIdZona());
                    sentencia.setInt(5, local.getIdLocal());
                } else {
                    sentencia.setInt(4, local.getIdLocal());
                }
                
                sentencia.executeUpdate();
                local.setError("<font color='blue'>Local modificat correctament");
                
            } else if (request.getSession().getAttribute("usuariinspector")!= null){
                sentencia = con.prepareStatement("UPDATE locals SET tipus = ?, restriccions = ?, preu = ? WHERE id = ?");
                sentencia.setString(1, local.getTipus());
                sentencia.setString(2, local.getRestriccions());
                sentencia.setFloat(3, local.getPreu());
                sentencia.setInt(4, local.getIdLocal());
                sentencia.executeUpdate();
                local.setError("<font color='blue'>Local modificat correctament");
            }
            
            
        }catch(Exception excepcio){
            local.setError("<font color='red'>Excepcio ocorreguda en actions.ModificarLocal:<br>" +
                    ""+excepcio.getMessage()+"</font>");
        } finally {
            try {
                if (con != null ) {
                    con.close();
                }
            } catch (Exception excepcio){
                local.setError("<font color='red'>Excepcio ocorreguda en actions.ModificarLocal:<br>" +
                        ""+excepcio.getMessage()+"</font>");
                return mapping.findForward("ok");
            }
        }
        return mapping.findForward("ok");
        
    }
}
